-- Tabele z pliku ZamowieniaStrukturaPG.sql muszą zostać utworzone najpierw.

SET search_path TO ZamowieniaPrzyklad;

CREATE VIEW R04_stan_zamieszkania_klientow
AS
SELECT DISTINCT StanZamKlienta
FROM Klienci;


CREATE VIEW R04_informacje_o_pracownikach
AS
SELECT Pracownicy.*
FROM Pracownicy;


CREATE VIEW R04_lista_cen_produktow
AS
SELECT NazwaProduktu, CenaDetaliczna
FROM Produkty;


CREATE VIEW R04_siedziby_dostawcow
AS
SELECT   MiastoDostawcy, NazwaDostawcy
FROM         Dostawcy
ORDER BY MiastoDostawcy;


CREATE VIEW R04_nazwy_dostawcow
AS
SELECT NazwaDostawcy
FROM Dostawcy;


CREATE VIEW R05_skorygowane_ceny_hurtowe
AS
SELECT NumerProduktu, CenaHurtowa, CenaHurtowa - (CenaHurtowa * 0.05) AS NowaCena
FROM Dostawcy_produktow;


CREATE VIEW R05_zamowienia_wedlug_klienta_i_daty
AS
SELECT   IDKlienta, DataZamowienia, NumerZamowienia
FROM         Zamowienia
ORDER BY IDKlienta, DataZamowienia DESC, NumerZamowienia;


CREATE VIEW R05_wartosc_magazynowa_produktu
AS
SELECT NazwaProduktu, CenaDetaliczna * StanMagazynowy AS WartoscMagazynowa
FROM Produkty;


CREATE VIEW R05_analiza_czasu_realizacji
AS
SELECT NumerZamowienia, DataZamowienia, DataWysylki, (DataWysylki - DataZamowienia) AS CzasRealizacji
FROM Zamowienia;


CREATE VIEW R05_adresy_dostawcow
AS
SELECT   NazwaDostawcy, 
  Concat(AdresDostawcy, ', ', MiastoDostawcy, '  ', StanSiedzDostawcy, '  ', KodPocztowyDostawcy) 
  AS PelnyAdresDostawcy, TelefonDostawcy
FROM         Dostawcy
ORDER BY NazwaDostawcy;


CREATE VIEW R06_dostawcy_z_Ballard_Bellevue_Redmond
AS
SELECT   NazwaDostawcy, MiastoDostawcy
FROM         Dostawcy
WHERE     (MiastoDostawcy IN ('Ballard', 'Bellevue', 'Redmond'))
ORDER BY NazwaDostawcy;


CREATE VIEW R06_zamowienia_klienta_1001
AS
SELECT NumerZamowienia, IDKlienta
FROM Zamowienia
WHERE IDKlienta = 1001;


CREATE VIEW R06_produkty_kosztujace_ponad_125
AS
SELECT   NazwaProduktu, CenaDetaliczna
FROM         Produkty
WHERE     (CenaDetaliczna >= 125)
ORDER BY NazwaProduktu;


CREATE VIEW R06_produkty_zawierajace_slowo_DOG
AS
SELECT   NazwaProduktu
FROM         Produkty
WHERE     (NazwaProduktu LIKE '%Dog%')
ORDER BY NazwaProduktu;


CREATE VIEW R06_dostawcy_bez_strony_internetowej
AS
SELECT   NazwaDostawcy, StronaInterDostawcy
FROM         Dostawcy
WHERE     (StronaInterDostawcy IS NULL)
ORDER BY NazwaDostawcy;


CREATE VIEW R08_klienci_i_daty_zamowien
AS
SELECT   Concat(Klienci.ImieKlienta,  ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Zamowienia.DataZamowienia
FROM         Klienci INNER JOIN
                      Zamowienia ON Klienci.IDKlienta = Zamowienia.IDKlienta
ORDER BY Zamowienia.DataZamowienia;


CREATE VIEW R08_klienci_ktorzy_kupili_rower_i_kask
AS
SELECT     CustRowery.ImieKlienta, CustRowery.NazwiskoKlienta
FROM         (SELECT DISTINCT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
              FROM          ((Klienci 
                              INNER JOIN Zamowienia 
                              ON Klienci.IDKlienta = Zamowienia.IDKlienta) 
                              INNER JOIN Dane_zamowien 
                              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
                              INNER JOIN Produkty 
                              ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
              WHERE      Produkty.NazwaProduktu LIKE '%Rower') CustRowery 
        INNER JOIN
             (SELECT DISTINCT Klienci.IDKlienta
              FROM          ((Klienci 
                              INNER JOIN Zamowienia 
                              ON Klienci.IDKlienta = Zamowienia.IDKlienta) 
                              INNER JOIN Dane_zamowien 
                              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)                                 INNER JOIN Produkty 
                              ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
              WHERE      Produkty.NazwaProduktu LIKE '%Kask%') CustHelmets 
        ON CustRowery.IDKlienta = CustHelmets.IDKlienta;


CREATE VIEW R08_klienci_i_pracownicy_z_tych_samych_miast
AS
SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Pracownicy.MiastoPracownika
FROM Klienci INNER JOIN Pracownicy ON (Klienci.MiastoKlienta = Pracownicy.MiastoPracownika);


CREATE VIEW R08_klienci_i_pracownicy_o_tym_samym_nazwisku
AS
SELECT Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Concat(Pracownicy.ImiePracownika, ' ', Pracownicy.NazwiskoPracownika) AS PersonaliaPracownika
FROM Klienci INNER JOIN Pracownicy ON (Klienci.NazwiskoKlienta = Pracownicy.NazwiskoPracownika);


CREATE VIEW R08_klienci_ktorzy_zamowili_kaski
AS
SELECT DISTINCT Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Produkty.NazwaProduktu LIKE '%Kask%';


CREATE VIEW R08_pracownicy_i_klienci
AS
SELECT DISTINCT Concat(Pracownicy.ImiePracownika, ' ', Pracownicy.NazwiskoPracownika) AS PersonaliaPracownika, Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta
FROM (Pracownicy INNER JOIN Zamowienia ON (Pracownicy.IDPracownika = Zamowienia.IDPracownika)) INNER JOIN Klienci ON (Klienci.IDKlienta = Zamowienia.IDKlienta);


CREATE VIEW R08_zamowienia_z_podzialem_na_produkty
AS
SELECT   Zamowienia.NumerZamowienia AS NrZamowienia, Zamowienia.DataZamowienia, Dane_zamowien.NumerProduktu AS NrProduktu, 
                      Produkty.NazwaProduktu AS Product, Dane_zamowien.CenaZakupu AS Cena, Dane_zamowien.ZamowionaIlosc AS Ilosc, 
                      Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc AS PosiadanaIlosc
FROM         Zamowienia INNER JOIN
                      Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia INNER JOIN
                      Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
ORDER BY NrZamowienia;


CREATE VIEW R08_produkty_i_kategorie
AS
SELECT Kategorie.OpisKategorii, Produkty.NazwaProduktu
FROM Kategorie INNER JOIN Produkty ON (Kategorie.IDKategorii = Produkty.IDKategorii);


CREATE VIEW R08_dostawcy_i_produkty_tansze_niz_100
AS
SELECT Dostawcy.NazwaDostawcy, Produkty.NazwaProduktu, Dostawcy_produktow.CenaHurtowa
FROM (Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dostawcy_produktow.NumerProduktu)
WHERE Dostawcy_produktow.CenaHurtowa < 100;


CREATE VIEW R09_wszyscy_klienci_i_dowolne_zamowienia_na_rowery
AS
SELECT  Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, RD.DataZamowienia, RD.NazwaProduktu, RD.ZamowionaIlosc, 
                      RD.CenaZakupu
FROM         Klienci LEFT OUTER JOIN
             (SELECT     Zamowienia.IDKlienta, Zamowienia.DataZamowienia, Produkty.NazwaProduktu, Dane_zamowien.ZamowionaIlosc, Dane_zamowien.CenaZakupu
              FROM          ((Zamowienia 
              INNER JOIN      Dane_zamowien 
              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
              INNER JOIN      Produkty 
              ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) 
              INNER JOIN      Kategorie 
              ON Kategorie.IDKategorii = Produkty.IDKategorii
              WHERE      Kategorie.OpisKategorii = 'Rowery') RD 
             ON Klienci.IDKlienta = RD.IDKlienta;


CREATE VIEW R09_wszystkie_produkty_dowolne_daty_zamowien
AS
SELECT     Produkty.NumerProduktu, Produkty.NazwaProduktu, OD.DataZamowienia
FROM         Produkty LEFT OUTER JOIN
             (SELECT DISTINCT Dane_zamowien.NumerProduktu, Zamowienia.DataZamowienia
              FROM          Zamowienia 
              INNER JOIN    Dane_zamowien 
              ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) OD 
             ON Produkty.NumerProduktu = OD.NumerProduktu;


CREATE VIEW R09_klienci_ktorzy_nie_kupili_kasku
AS
SELECT     Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM         Klienci LEFT OUTER JOIN
               (SELECT     Zamowienia.IDKlienta, Produkty.NazwaProduktu
                FROM          Produkty 
                INNER JOIN    (Zamowienia 
                INNER JOIN    Dane_zamowien 
                ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
                ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                WHERE      Produkty.NazwaProduktu LIKE '%Kask%') HelmetZamowienia 
            ON Klienci.IDKlienta = HelmetZamowienia.IDKlienta
WHERE     (HelmetZamowienia.IDKlienta IS NULL);


CREATE VIEW R09_klienci_bez_sprzedawcy_z_tym_samym_kodem
AS
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.KodPocztowyKlienta
FROM Klienci LEFT JOIN Pracownicy ON (Klienci.KodPocztowyKlienta = Pracownicy.KodPocztowyPracownika)
WHERE Pracownicy.IDPracownika Is Null;


CREATE VIEW R09_produkty_nigdy_nie_zamawiane
AS
SELECT Produkty.NumerProduktu, Produkty.NazwaProduktu
FROM Produkty LEFT JOIN Dane_zamowien ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Dane_zamowien.NumerZamowienia Is Null;


CREATE VIEW R10_klienci_na_kaski_i_dostawcy_kaskow
AS
SELECT  Concat(Klienci.NazwiskoKlienta, ', ', Klienci.ImieKlienta) AS ImieINazwisko, Produkty.NazwaProduktu, 'Klient' AS IDWiersza
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%Kask%'
UNION
SELECT     Dostawcy.NazwaDostawcy, Produkty.NazwaProduktu, 'Dostawca' AS IDWiersza
FROM         (Dostawcy INNER JOIN
                      Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dostawcy_produktow.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%Kask%';


CREATE VIEW R10_klienci_zamowili_rowery_UNION_klienci_zamowili_kaski
AS
SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 'Rower' AS TypProduktu
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%Rower%'
UNION
SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 'Kask' AS TypProduktu
FROM         ((Klienci INNER JOIN
                      Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN
                      Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN
                      Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE     Produkty.NazwaProduktu LIKE '%Kask%';


CREATE VIEW R10_klienci_ktorzy_zamowili_rowery_lub_kaski
AS
SELECT DISTINCT Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)) INNER JOIN Produkty ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
WHERE Produkty.NazwaProduktu LIKE '%Rower%' OR Produkty.NazwaProduktu LIKE '%Kask%';


CREATE VIEW R10_Klienci_UNION_ALL_Pracownicy
AS
SELECT   Klienci.ImieKlienta, Klienci.NazwiskoKlienta,  
         Klienci.AdresKlienta, Klienci.MiastoKlienta, 
         Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta
  FROM Klienci
UNION ALL
SELECT   Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, 
         Pracownicy.AdresPracownika, Pracownicy.MiastoPracownika, 
         Pracownicy.StanZamPracownika, Pracownicy.KodPocztowyPracownika
  FROM Pracownicy
ORDER BY KodPocztowyKlienta;


CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         Klienci
WHERE     (IDKlienta = ANY
                          (SELECT     Zamowienia.IDKlienta
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria'));


CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria_EXISTS
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         Klienci
WHERE     EXISTS
                          (SELECT     *
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      (Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria') AND Klienci.IDKlienta = Zamowienia.IDKlienta);


CREATE VIEW R11_klienci_ktorzy_kupili_odziez_albo_akcesoria_IN
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         Klienci
WHERE     (IDKlienta IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          ((Zamowienia INNER JOIN
                                                   Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) INNER JOIN
                                                   Produkty ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) INNER JOIN
                                                   Kategorie ON Kategorie.IDKategorii = Produkty.IDKategorii
                            WHERE      Kategorie.OpisKategorii = 'Odzież' OR
                                                   Kategorie.OpisKategorii = 'Akcesoria'));


CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS
    (SELECT *
    FROM (Zamowienia
    INNER JOIN Dane_zamowien
    ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
    INNER JOIN Produkty
    ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
    WHERE Produkty.IDKategorii = 2
    AND Zamowienia.IDKlienta = Klienci.IDKlienta);


CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Zamowienia.IDKlienta FROM ((Zamowienia 
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia) 
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu) 
INNER JOIN Kategorie
ON Kategorie.IDKategorii = Produkty.IDKategorii 
WHERE Kategorie.OpisKategorii = 'Rowery');


CREATE VIEW R11_klienci_ktorzy_zamowili_rowery_JOIN
AS 
SELECT DISTINCT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM ((Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta)
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii=2;


CREATE VIEW R11_daty_ostatnich_zamowien_produktow
AS
SELECT Produkty.NumerProduktu, Produkty.NazwaProduktu, (SELECT max(Zamowienia.DataZamowienia) FROM Zamowienia INNER JOIN Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia WHERE Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) AS OstatnieZamowienie
FROM Produkty;


CREATE VIEW R11_produkty_nigdy_nie_zamawiane
AS
SELECT Produkty.NazwaProduktu
FROM Produkty
WHERE Produkty.NumerProduktu NOT IN (SELECT Dane_zamowien.NumerProduktu FROM Dane_zamowien);


CREATE VIEW R11_liczba_produktow_oferowanych_przez_dostawcow
AS
SELECT NazwaDostawcy, (SELECT count(*) FROM Dostawcy_produktow WHERE Dostawcy_produktow.IDDostawcy = Dostawcy.IDDostawcy) AS LiczbaProduktowDostawcow
FROM Dostawcy;


CREATE VIEW R12_srednia_cena_roweru_gorskiego
AS
SELECT avg(CenaDetaliczna) AS SredniaCena
FROM Produkty
WHERE NazwaProduktu LIKE '%Rower górski%';


CREATE VIEW R12_data_najnowszego_zamowienia
AS
SELECT max(DataZamowienia) AS DataNajnowszegoZamowienia
FROM Zamowienia;


CREATE VIEW R12_liczba_klientow_z_Kalifornii
AS
SELECT count(*) AS LiczbaKlientowZKal
FROM Klienci
WHERE StanZamKlienta = 'CA';


CREATE VIEW R12_cena_mniejszalubrowna_sredniej
AS
SELECT Produkty.NazwaProduktu
FROM Produkty
WHERE Produkty.CenaDetaliczna <= (SELECT Avg(CenaDetaliczna) FROM Produkty);


CREATE VIEW R12_cena_zakupu_a_srednia_cena_detaliczna
AS
SELECT DISTINCT NazwaProduktu, Produkty.NumerProduktu
FROM Produkty INNER JOIN Dane_zamowien ON (Produkty.NumerProduktu =  Dane_zamowien.NumerProduktu)
WHERE Dane_zamowien.CenaZakupu >=     (SELECT avg(CenaDetaliczna)     FROM Produkty);


CREATE VIEW R12_calkowita_wartosc_zamowienia_numer_8
AS
SELECT sum(ZamowionaIlosc * CenaZakupu) AS CalkowitaWartoscZamowienia
FROM Dane_zamowien
WHERE NumerZamowienia = 8;


CREATE VIEW R13_wartosci_zamowien_wg_klienta_i_daty
AS
SELECT Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Zamowienia.DataZamowienia, sum(Dane_zamowien.CenaZakupu *     Dane_zamowien.ZamowionaIlosc) AS LacznaWartosc
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
GROUP BY Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.DataZamowienia;


CREATE VIEW R13_sprzedaz_wedlug_produktow
AS
SELECT Produkty.NazwaProduktu, sum(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) AS LacznaSprzedaz
FROM Produkty INNER JOIN Dane_zamowien ON (Produkty.NumerProduktu = Dane_zamowien.NumerProduktu)
GROUP BY Produkty.NazwaProduktu;


CREATE VIEW R13_sredni_czas_dostawy
AS
SELECT Dostawcy.NazwaDostawcy, avg(Dostawcy_produktow.TerminDostarczenia) AS SredniCzasDostawy
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy;


CREATE VIEW R13_liczba_produktow_od_dostawcow_grupowanie
AS
SELECT Dostawcy.NazwaDostawcy, count(Dostawcy_produktow.NumerProduktu) AS LiczbaProduktow
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy;


CREATE VIEW R13_liczba_produktow_od_dostawcow_podzapytanie
AS
SELECT NazwaDostawcy, (SELECT count(*) FROM Dostawcy_produktow WHERE Dostawcy_produktow.IDDostawcy = Dostawcy.IDDostawcy) AS LiczbaProduktowDostawcow
FROM Dostawcy;


CREATE VIEW R14_wartosci_zamowien_wg_klienta_i_daty_wieksze_niz_1000
AS
SELECT CONCAT(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Zamowienia.DataZamowienia, sum(Dane_zamowien.CenaZakupu *     Dane_zamowien.ZamowionaIlosc) AS LacznaWartosc
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
GROUP BY Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.DataZamowienia
HAVING sum(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) > 1000;


CREATE VIEW R14_sprzedaz_wg_produktu_wieksza_niz_srednia_w_kategorii
AS
SELECT     Produkty.NazwaProduktu, SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) AS LacznaSprzedaz
FROM         Produkty 
INNER JOIN   Dane_zamowien 
  ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
GROUP BY Produkty.IDKategorii, Produkty.NazwaProduktu
HAVING      (SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) >
                (SELECT     AVG(SumCategory)
                 FROM       
                    (SELECT     P2.IDKategorii, SUM(OD2.CenaZakupu * OD2.ZamowionaIlosc) AS SumCategory
                     FROM          Produkty AS P2 
                     INNER JOIN    Dane_zamowien AS OD2 
                       ON P2.NumerProduktu = OD2.NumerProduktu
                     GROUP BY P2.IDKategorii, P2.NumerProduktu) AS S
                 WHERE      S.IDKategorii = Produkty.IDKategorii
                 GROUP BY IDKategorii));


CREATE VIEW R14_liczba_zamowien_na_jeden_produkt
AS
SELECT     COUNT(*) AS LiczbaZamJedenProdukt
FROM         (SELECT     Dane_zamowien.NumerZamowienia
                       FROM          Dane_zamowien
                       GROUP BY Dane_zamowien.NumerZamowienia
                       HAVING      COUNT(*) = 1) ZamowieniaJednostkowe;


CREATE VIEW R14_sredni_czas_dostawy_wiekszy_niz_ogolny_czas_sredni
AS
SELECT Dostawcy.NazwaDostawcy, avg(Dostawcy_produktow.TerminDostarczenia) AS SredniCzasDostawy
FROM Dostawcy INNER JOIN Dostawcy_produktow ON (Dostawcy.IDDostawcy = Dostawcy_produktow.IDDostawcy)
GROUP BY Dostawcy.NazwaDostawcy
HAVING avg(Dostawcy_produktow.TerminDostarczenia) > (SELECT avg(TerminDostarczenia) FROM Dostawcy_produktow);


CREATE VIEW R14_stany_z_Zachodniego_Wybrzeza_duze_zamowienia
AS
SELECT Klienci.StanZamKlienta, sum(Dane_zamowien.ZamowionaIlosc *     Dane_zamowien.CenaZakupu) AS SumaZamowien
FROM (Klienci INNER JOIN Zamowienia ON (Klienci.IDKlienta = Zamowienia.IDKlienta)) INNER JOIN Dane_zamowien ON (Zamowienia.NumerZamowienia =     Dane_zamowien.NumerZamowienia)
WHERE Klienci.StanZamKlienta IN ('WA', 'OR', 'CA')
GROUP BY Klienci.StanZamKlienta
HAVING sum(Dane_zamowien.ZamowionaIlosc *     Dane_zamowien.CenaZakupu) > 1000000;


CREATE VIEW R18_klienci_ktorzy_kupili_rower_i_kask_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS 
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta)
AND EXISTS
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.NazwaProduktu LIKE '%Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta);


CREATE VIEW R18_klienci_ktorzy_kupili_rowery_ale_nie_kaski_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS 
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta)
AND NOT EXISTS
(SELECT *
FROM (Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
WHERE Produkty.NazwaProduktu LIKE '%Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta);


CREATE VIEW R18_klienci_ktorzy_kupili_rowery_ale_nie_kaski
AS 
SELECT IDKlienta, ImieKlienta, NazwiskoKlienta
FROM Klienci
WHERE (IDKlienta IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          (Zamowienia
INNER JOIN
                                                   Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN
                                                   Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                            WHERE      Produkty.IDKategorii = 2)) 
          
AND (IDKlienta NOT IN
                          (SELECT     Zamowienia.IDKlienta
                            FROM          (Zamowienia
INNER JOIN
                                                   Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN
                                                   Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu
                            WHERE      Produkty.NazwaProduktu LIKE '%Kask%'));


CREATE VIEW R18_klienci_na_rower_i_kask_jedno_zamowienie
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.NumerZamowienia, Zamowienia.DataZamowienia
FROM Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE EXISTS  (SELECT * FROM (Zamowienia As O2
INNER JOIN Dane_zamowien
ON O2.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu WHERE Produkty.IDKategorii = 2
AND Zamowienia.IDKlienta = Klienci.IDKlienta
AND O2.NumerZamowienia = Zamowienia.NumerZamowienia)
AND EXISTS (SELECT * FROM (Zamowienia As O3 
INNER JOIN Dane_zamowien
ON O3.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Produkty.NumerProduktu = Dane_zamowien.NumerProduktu WHERE Produkty.NazwaProduktu LIKE '%Kask%'
AND Zamowienia.IDKlienta = Klienci.IDKlienta
AND O3.NumerZamowienia = Zamowienia.NumerZamowienia);


CREATE VIEW R18_klienci_bez_zamowien_JOIN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta
FROM Klienci LEFT JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE Zamowienia.NumerZamowienia Is Null;


CREATE VIEW R18_klienci_bez_zamowien_NOT_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT Zamowienia.IDKlienta FROM Zamowienia);


CREATE VIEW R18_klienci_ktorzy_nie_kupili_rowerow_ani_opon_NOTIN_1
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii IN (2, 6));


CREATE VIEW R18_klienci_ktorzy_nie_kupili_rowerow_ani_opon_NOTIN_2
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii = 2)
AND Klienci.IDKlienta NOT IN 
(SELECT IDKlienta FROM
(Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia)
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu
WHERE Produkty.IDKategorii = 6);


CREATE VIEW R18_zamowienia_na_rowery_ale_nie_na_kaski_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Zamowienia.NumerZamowienia, Zamowienia.DataZamowienia
FROM Klienci
INNER JOIN Zamowienia
ON Klienci.IDKlienta=Zamowienia.IDKlienta
WHERE EXISTS  (SELECT NumerZamowienia  FROM (Dane_zamowien
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii WHERE Kategorie.OpisKategorii = 'Rowery'
AND Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia)
AND NOT EXISTS  (SELECT *  FROM Dane_zamowien
INNER JOIN Produkty
ON Dane_zamowien.NumerProduktu = Produkty.NumerProduktu WHERE Produkty.NazwaProduktu LIKE '%Kask%'
AND Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia);


CREATE VIEW R18_dostawcy_akcesoriow_uchwytow_odziezy
AS 
SELECT Dostawcy.IDDostawcy, Dostawcy.NazwaDostawcy
FROM Dostawcy
WHERE Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Akcesoria')
AND Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Uchwyty samochodowe')
AND Dostawcy.IDDostawcy IN
(SELECT IDDostawcy 
  FROM (Dostawcy_produktow
INNER JOIN Produkty
ON Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)
INNER JOIN Kategorie
ON Produkty.IDKategorii = Kategorie.IDKategorii
  WHERE Kategorie.OpisKategorii = 'Odzież');


CREATE VIEW R19_klienci_ktorzy_zlozyli_zamowienia_1_tydz_grud_2017
AS 
SELECT        IDKlienta, ImieKlienta, NazwiskoKlienta, (CASE WHEN IDKlienta IN 
                            (SELECT        IDKlienta 
                              FROM            Zamowienia 
                              WHERE        DataZamowienia BETWEEN CAST('2017-12-01' AS Date) AND CAST('2017-12-07' AS Date)) 
                            THEN 'Zamówione' 
                            ELSE 'Nie zamówione' END) AS ZamPierwszyTydzGr2017 
FROM            Klienci;



CREATE VIEW R19_nazwy_stanow_zamieszkania_klientow
AS
SELECT        ImieKlienta, NazwiskoKlienta, 
                         (CASE StanZamKlienta WHEN 'TX' THEN 'Teksas' WHEN 'CA' THEN 'Kalifornia' WHEN 'OR' THEN 'Oregon' WHEN 'WA' THEN 'Waszyngton' ELSE 'Nieznany' END) 
                         AS NazwaStanuZamKlienta
FROM           Klienci;


CREATE VIEW R19_wiek_pracownikow_na_15lutego2018  
AS 
SELECT        IDPracownika, ImiePracownika, NazwiskoPracownika, 
EXTRACT(YEAR FROM CAST('2018-02-15' As Date)) - EXTRACT(YEAR FROM DataUrodzPracownika) - 
(CASE WHEN EXTRACT(MONTH FROM DataUrodzPracownika) < 2 
        THEN 0 
      WHEN EXTRACT(MONTH FROM DataUrodzPracownika) > 2 
        THEN 1 
      WHEN EXTRACT(DAY FROM DataUrodzPracownika) > 15 
        THEN 1 
        ELSE 0 END) AS WiekPrac 
FROM            Pracownicy;


CREATE VIEW R19_ocena_popytu_na_produkty 
AS 
SELECT NumerProduktu, NazwaProduktu, 
      (CASE  
        WHEN (SELECT SUM(ZamowionaIlosc) 
              FROM   Dane_zamowien
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 200 
         THEN 'Słaby' 
        WHEN
 (SELECT SUM(ZamowionaIlosc) 
               FROM   Dane_zamowien 
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 500 
         THEN 'Średni' 
         WHEN (SELECT SUM(ZamowionaIlosc) 
               FROM   Dane_zamowien
 
              WHERE  (Dane_zamowien.NumerProduktu = Produkty.NumerProduktu)) <= 1000 
          THEN 'Dobry' 
        ELSE 'Doskonały' END) AS Popyt 
FROM            Produkty;




CREATE VIEW R19_produkty_zamawiane_w_grudniu_2017
AS
SELECT        NumerProduktu, NazwaProduktu, (CASE WHEN Produkty.NumerProduktu IN
                             (SELECT        Dane_zamowien.NumerProduktu
                               FROM            Dane_zamowien INNER JOIN
                                                         Zamowienia ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia
                               WHERE        (Zamowienia.DataZamowienia BETWEEN CAST('2017-12-01' AS Date) AND CAST('2017-12-31' AS Date))) THEN 'Zamówione' ELSE 'Nie zamówione' END) 
                         AS ProduktZamowiony
FROM            Produkty;


CREATE VIEW R20_klienci_wszystkie_produkty_info_o_zakupie
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, 
  Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, Kategorie.OpisKategorii, 
  Produkty.NumerProduktu, Produkty.NazwaProduktu, Produkty.CenaDetaliczna, 
  (CASE WHEN Klienci.IDKlienta IN 
      (SELECT Zamowienia.IDKlienta 
       FROM ORDERS INNER JOIN Dane_zamowien ON Zamowienia.NumerZamowienia = Dane_zamowien.NumerZamowienia 
       WHERE Dane_zamowien.NumerProduktu = Produkty.NumerProduktu) 
   THEN 'Kupiłeś to!' ELSE ' ' END) AS ProduktZamowiony
FROM Klienci, Kategorie
INNER JOIN Produkty
ON Kategorie.IDKategorii=Produkty.IDKategorii
ORDER BY Klienci.IDKlienta, Kategorie.OpisKategorii, Produkty.NumerProduktu;


CREATE VIEW R20_katalog_dla_klientow
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, 
  Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, Kategorie.OpisKategorii, 
  Produkty.NumerProduktu, Produkty.NazwaProduktu, Produkty.CenaDetaliczna
FROM Klienci, Kategorie
INNER JOIN Produkty
ON Kategorie.IDKategorii=Produkty.IDKategorii
ORDER BY Klienci.IDKlienta, Kategorie.OpisKategorii, Produkty.NumerProduktu;


CREATE VIEW R20_kupony_za_zakupy_w_grudniu_2017
AS 
SELECT ztblKuponyZakupowe.LiczbaKuponow, WartZamGrud.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
  Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta, WartZamGrud.Zakupy
FROM ztblKuponyZakupowe, Klienci
INNER JOIN (SELECT Zamowienia.IDKlienta, Sum((CenaZakupu)*(ZamowionaIlosc)) AS Zakupy FROM Zamowienia
INNER JOIN Dane_zamowien
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia WHERE Zamowienia.DataZamowienia Between CAST('2017-12-01' AS date) 
AND CAST('2017-12-31' AS date) GROUP BY Zamowienia.IDKlienta)  AS WartZamGrud
ON Klienci.IDKlienta=WartZamGrud.IDKlienta
WHERE WartZamGrud.Zakupy BETWEEN ztblKuponyZakupowe.ProgDolnyZakupu
AND ztblKuponyZakupowe.ProgGornyZakupu;


CREATE VIEW R20_wydruk_kuponow_znizkowych_dla_klientow
AS 
SELECT R20_kupony_za_zakupy_w_grudniu_2017.IDKlienta, R20_kupony_za_zakupy_w_grudniu_2017.ImieKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2017.NazwiskoKlienta, R20_kupony_za_zakupy_w_grudniu_2017.AdresKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2017.MiastoKlienta, R20_kupony_za_zakupy_w_grudniu_2017.StanZamKlienta, 
  R20_kupony_za_zakupy_w_grudniu_2017.KodPocztowyKlienta
FROM ztblNumeryKolejne, R20_kupony_za_zakupy_w_grudniu_2017
WHERE R20_kupony_za_zakupy_w_grudniu_2017.LiczbaKuponow >= ztblNumeryKolejne.Kolejnosc
ORDER BY R20_kupony_za_zakupy_w_grudniu_2017.IDKlienta;


CREATE VIEW R20_etykiety_do_korespondencji_z_klientami_z_pominieciem_5
AS 
SELECT ' ' As ImieKlienta, ' ' As NazwiskoKlienta, ' ' As AdresKlienta, ' ' As MiastoKlienta, ' ' As StanZamKlienta, ' ' As KodPocztowyKlienta 
FROM ztblNumeryKolejne
WHERE ztblNumeryKolejne.Kolejnosc <= 5
UNION ALL SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta
FROM Klienci
ORDER BY KodPocztowyKlienta, NazwiskoKlienta;


CREATE VIEW R20_pracownicy_i_klienci_z_tego_samego_stanu
AS 
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
  Klienci.NumKierKlienta, Klienci.TelefonKlienta, 
  (CASE WHEN Klienci.IDKlienta IN (SELECT Zamowienia.IDKlienta FROM Zamowienia WHERE Zamowienia.IDPracownika = Pracownicy.IDPracownika) 
        THEN 'Zamawiał od ciebie' ELSE ' ' END) AS StatusKlienta
FROM Pracownicy, Klienci
WHERE Pracownicy.StanZamPracownika=Klienci.StanZamKlienta;


CREATE VIEW R20_zakresy_cen_produktow
AS 
SELECT ztblZakresyCen.KategoriaCenowa, Produkty.NazwaProduktu, Produkty.CenaDetaliczna
FROM ztblZakresyCen, Produkty
WHERE Produkty.CenaDetaliczna Between ztblZakresyCen.ProgDolny
AND ztblZakresyCen.ProgGorny;


CREATE VIEW R20_sprzedaz_produktow_wszystkie_miesiace_2017_2018
AS 
SELECT ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu, 
   (SELECT Sum(Dane_zamowien.ZamowionaIlosc*Dane_zamowien.CenaZakupu) AS WartSprz 
    FROM  (Produkty AS P2 INNER JOIN Dane_zamowien 
      ON P2.NumerProduktu=Dane_zamowien.NumerProduktu) 
	INNER JOIN Zamowienia ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
    WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca AND ztblMiesiace.KoniecMiesiaca
      AND P2.NumerProduktu = Produkty.NumerProduktu) AS Sprzedaz
FROM ztblMiesiace, Produkty
WHERE ztblMiesiace.NumerRoku BETWEEN 2017 AND 2018;


CREATE VIEW R20_sprzedaz_miesieczna_z_podzialem_na_produkty
AS 
SELECT ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu, Sum(Dane_zamowien.ZamowionaIlosc*Dane_zamowien.CenaZakupu) AS Sprzedaz
FROM ztblMiesiace, (Produkty
INNER JOIN Dane_zamowien
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu)
INNER JOIN Zamowienia
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu
ORDER BY ztblMiesiace.MiesiacRok, Produkty.NazwaProduktu;


CREATE VIEW R20_sprzedaz_miesieczna_tabelarycznie
AS 
SELECT Produkty.NazwaProduktu, SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Styczen) AS Styczen, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Luty) AS Luty, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Marzec) AS Marzec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Kwiecien) AS Kwiecien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Maj) AS Maj, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Czerwiec) AS Czerwiec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Lipiec) AS Lipiec, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Sierpien) AS Sierpien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Wrzesien) AS Wrzesien, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Pazdziernik) AS Pazdziernik, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Listopad) AS Listopad, 
  SUM(Dane_zamowien.CenaZakupu*Dane_zamowien.ZamowionaIlosc*ztblMiesiace.Grudzien) AS Grudzien
FROM ztblMiesiace, (Produkty
INNER JOIN Dane_zamowien
ON Produkty.NumerProduktu=Dane_zamowien.NumerProduktu)
INNER JOIN Zamowienia
ON Zamowienia.NumerZamowienia=Dane_zamowien.NumerZamowienia
WHERE Zamowienia.DataZamowienia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY Produkty.NazwaProduktu;


CREATE VIEW R20_etykiety_produktow_na_stanie
AS 
SELECT ztblNumeryKolejne.Kolejnosc, Produkty.NumerProduktu, Produkty.NazwaProduktu
FROM ztblNumeryKolejne, Produkty
WHERE ztblNumeryKolejne.Kolejnosc<=Produkty.StanMagazynowy
ORDER BY Produkty.NumerProduktu, ztblNumeryKolejne.Kolejnosc;


CREATE VIEW R21_katproduktow_stanklienta_przychod_CUBE
AS
SELECT PC.OpisKategorii, C.StanZamKlienta, 
  SUM(OD.CenaZakupu * OD.ZamowionaIlosc) AS Przychod
FROM Zamowienia AS O 
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Klienci AS C
    ON C.IDKlienta = O.IDKlienta
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu
  INNER JOIN Kategorie AS PC
    ON PC.IDKategorii = P.IDKategorii 
GROUP BY CUBE (PC.OpisKategorii, C.StanZamKlienta);


CREATE VIEW R21_katproduktow_stanklienta_przychod_ROLLUP
AS
SELECT PC.OpisKategorii, C.StanZamKlienta, 
  COUNT(DISTINCT O.NumerZamowienia) AS LiczbaZamowien, 
  SUM(OD.CenaZakupu * OD.ZamowionaIlosc) AS Przychod
FROM Zamowienia AS O 
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Klienci AS C
    ON C.IDKlienta = O.IDKlienta
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu
  INNER JOIN Kategorie AS PC
    ON PC.IDKategorii = P.IDKategorii 
GROUP BY ROLLUP (PC.OpisKategorii, C.StanZamKlienta);


CREATE VIEW R21_katproduktow_siedzibadostawcy_iloscnastanie_CUBE
AS
SELECT PC.OpisKategorii, V.StanSiedzDostawcy, SUM(P.StanMagazynowy) AS IlosNaStanie
FROM Produkty AS P 
  INNER JOIN Kategorie AS PC
    ON PC.IDKategorii = P.IDKategorii
  INNER JOIN Dostawcy_produktow AS PV
    ON PV.NumerProduktu = P.NumerProduktu
  INNER JOIN Dostawcy AS V
    ON V.IDDostawcy = PV.IDDostawcy 
GROUP BY CUBE (PC.OpisKategorii, V.StanSiedzDostawcy);


CREATE VIEW R21_katproduktow_siedzibadostawcy_iloscnastanie_ROLLUP
AS
SELECT PC.OpisKategorii, V.StanSiedzDostawcy, SUM(P.StanMagazynowy) AS IlosNaStanie
FROM Produkty AS P 
  INNER JOIN Kategorie AS PC
    ON PC.IDKategorii = P.IDKategorii
  INNER JOIN Dostawcy_produktow AS PV
    ON PV.NumerProduktu = P.NumerProduktu
  INNER JOIN Dostawcy AS V
    ON V.IDDostawcy = PV.IDDostawcy 
GROUP BY ROLLUP (PC.OpisKategorii, V.StanSiedzDostawcy);


CREATE VIEW R21_siedzibadostawcy_liczba_w_kategorii_ROLLUP
AS
SELECT V.StanSiedzDostawcy, C.OpisKategorii, Count(*) AS Produkty
FROM Dostawcy AS V
  INNER JOIN Dostawcy_produktow AS PV
    ON PV.IDDostawcy = PV.IDDostawcy  
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = PV.NumerProduktu  
  INNER JOIN Kategorie AS C
    ON C.IDKategorii = P.IDKategorii 
GROUP BY ROLLUP (V.StanSiedzDostawcy, C.OpisKategorii);


CREATE VIEW R22_ranking_klientow_wg_liczby_zamowien
AS
SELECT C.IDKlienta, C.ImieKlienta || ' ' || C.NazwiskoKlienta AS Klient,
  COUNT(DISTINCT O.NumerZamowienia) AS OtrzymaneZamowienia,
  RANK() OVER (
    ORDER BY COUNT(DISTINCT O.NumerZamowienia) DESC
  ) AS Pozycja
FROM Klienci AS C
  LEFT JOIN Zamowienia AS O
    ON O.IDKlienta = C.IDKlienta
GROUP BY C.IDKlienta, C.ImieKlienta, C.NazwiskoKlienta;

CREATE VIEW R22_numerowanie_klientow
AS
SELECT ROW_NUMBER() OVER (
  ORDER BY NazwiskoKlienta, ImieKlienta
) AS NumerWiersza,
  C.IDKlienta,
  C.ImieKlienta || ' ' || C.NazwiskoKlienta AS PersonaliaKlienta,
  C.StanZamKlienta
FROM Klienci AS C;


CREATE VIEW R22_numerowanie_klientow_w_stanach
AS
SELECT ROW_NUMBER() OVER (
  PARTITION BY StanZamKlienta
  ORDER BY NazwiskoKlienta, ImieKlienta
) AS NumerWiersza,
  C.IDKlienta,
  C.ImieKlienta || ' ' || C.NazwiskoKlienta AS PersonaliaKlienta,
  C.StanZamKlienta
FROM Klienci AS C;


CREATE VIEW R22_ranking_sprzedazy_pracownikow
AS
SELECT E.IDPracownika, E.ImiePracownika || ' ' || E.NazwiskoPracownika AS Pracownik,
  COUNT(DISTINCT O.NumerZamowienia) AS OtrzymaneZamowienia,
  RANK() OVER (
    ORDER BY COUNT(DISTINCT O.NumerZamowienia) DESC
  ) AS Kolejnosc
FROM Pracownicy AS E
  INNER JOIN Zamowienia AS O
    ON O.IDPracownika = E.IDPracownika
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
GROUP BY E.IDPracownika, E.ImiePracownika, E.NazwiskoPracownika;

CREATE VIEW R22_zliczanie_zamowien_wgfaktury_ROWS_RANGE
AS
SELECT O.NumerZamowienia AS NrZamowienia, P.NazwaProduktu,
  COUNT(*) OVER (
    PARTITION BY O.NumerZamowienia
  ) AS Total,
  COUNT(*) OVER (
    ORDER BY O.NumerZamowienia
    ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
  ) AS SumaZWierszy,
  COUNT(*) OVER (
    ORDER BY O.NumerZamowienia
    RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
  ) AS SumaZZakresow
FROM Zamowienia AS O
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu;


CREATE VIEW R22_wartosci_zamowien_wgfaktury
AS
SELECT C.ImieKlienta || ' ' || C.NazwiskoKlienta AS Klient,
  O.NumerZamowienia, P.NazwaProduktu,
  OD.ZamowionaIlosc, OD.CenaZakupu, 
  SUM(OD.CenaZakupu) OVER (PARTITION BY O.NumerZamowienia) AS WartoscCalkowita
FROM Zamowienia AS O
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Klienci AS C
    ON C.IDKlienta = O.IDKlienta
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu;


CREATE VIEW R22_sumy_zamowien_wg_wartosci_faktury
AS
SELECT C.ImieKlienta || ' ' || C.NazwiskoKlienta AS Klient,
  O.NumerZamowienia, 
  SUM(OD.ZamowionaIlosc) AS LacznaIlosc,
  SUM(OD.CenaZakupu) AS TotalPrice,
  RANK() OVER (ORDER BY SUM(OD.CenaZakupu) DESC) AS Pozycja
FROM Zamowienia AS O
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Klienci AS C
    ON C.IDKlienta = O.IDKlienta
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu
GROUP BY C.ImieKlienta, C.NazwiskoKlienta, O.NumerZamowienia;


CREATE VIEW R22_zamowienia_min_maks
AS
SELECT O.NumerZamowienia, 
  C.ImieKlienta || ' ' || C.NazwiskoKlienta AS Klient,
  P.NazwaProduktu, 
  OD.ZamowionaIlosc,
  SUM(OD.ZamowionaIlosc) OVER (
    PARTITION BY O.NumerZamowienia 
  ) AS LacznaIlosc,
  SUM(OD.ZamowionaIlosc) OVER (
    PARTITION BY O.NumerZamowienia 
    ORDER BY O.NumerZamowienia 
    ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS Ilosc3,
  MIN(OD.ZamowionaIlosc) OVER (
    PARTITION BY O.NumerZamowienia 
    ORDER BY O.NumerZamowienia 
    ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS NajnizszaZ3,
  MAX(OD.ZamowionaIlosc) OVER (
    PARTITION BY O.NumerZamowienia 
    ORDER BY O.NumerZamowienia 
    ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS NajwyzszaZ3
FROM Zamowienia AS O
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Klienci AS C
    ON C.IDKlienta = O.IDKlienta
  INNER JOIN Produkty AS P
    ON P.NumerProduktu  = OD.NumerProduktu;


CREATE VIEW R22_laczne_wartosci_sprzedazy
AS
SELECT DISTINCT C.OpisKategorii, 
  SUM(OD.CenaZakupu) OVER () AS LacznaSprzedaz,
  SUM(OD.CenaZakupu) OVER (
    PARTITION BY C.OpisKategorii
  ) AS SprzedazWKat
FROM Zamowienia AS O
  INNER JOIN Dane_zamowien AS OD
    ON OD.NumerZamowienia = O.NumerZamowienia
  INNER JOIN Produkty AS P
    ON P.NumerProduktu = OD.NumerProduktu
  INNER JOIN Kategorie AS C
    ON C.IDKategorii = P.IDKategorii;


CREATE VIEW R22_laczne_wartosci_sprzedazy_z_null
AS
SELECT DISTINCT C.OpisKategorii, 
  SUM(OD.CenaZakupu) OVER () AS LacznaSprzedaz,
  COALESCE(SUM(OD.CenaZakupu) OVER (
    PARTITION BY C.OpisKategorii
  ), 0) AS SprzedazWKat
FROM Kategorie AS C
  LEFT JOIN Produkty AS P
    ON P.IDKategorii = C.IDKategorii 
  LEFT JOIN Dane_zamowien AS OD
    ON OD.NumerProduktu = P.NumerProduktu
  LEFT JOIN Zamowienia AS O
    ON O.NumerZamowienia = OD.NumerZamowienia;

